/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.repair.panel;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemFilter;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystem;
import com.ibm.hwmca.fw.service.managedsystem.ManagedSystemManager;
import com.ibm.hwmca.fw.service.serviceaction.ServiceAction;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionFactory;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionType;
import com.ibm.hwmca.fw.tasklet.SynchronousPanelTasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.panel.repair.SelMenuPanelBean;
import com.ibm.hwmca.xfw.repair.panel.CommonPanelFunctions;
import com.ibm.hwmca.xfw.repair.panel.MachineInfoPanelHandler;
import com.ibm.hwmca.xfw.repair.panel.XFConstants;
import com.ibm.hwmca.xfw.repair.utils.XRVUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SelMenuPanelHandler {
    private static final String TRACE_MASKT = "XRVX047T";
    private static final String TRACE_MASKF = "XRVX047F";
    private static final String TRACE_MASKD = "XRVX047D";
    private static final LocalizableText OPEN = new LocalizableText("com.ibm.hwmca.base.res.text", "perfcons.open");
    private static final LocalizableText DELAYED = new LocalizableText("com.ibm.hwmca.base.res.text", "perfcons.delayed");
    private static final int PROBLEM_NUMBER = 0;
    private static final int DATE_TIME = 1;
    private static final int REF_CODE = 2;
    private static final int STATUS = 3;
    private ProblemManager problemManager;
    private boolean dataUpToDate = false;
    private SynchronousPanelTasklet displayHandle;
    private boolean exit = false;
    private PropertyChangeListener myPropertyChangeListenerAdapter;
    private ServiceAction repair = null;
    private Map problemMap;
    private ComparatorForSort comparator = new ComparatorForSort();
    private NumericComparatorForSort numericComparator = new NumericComparatorForSort();
    private static final OpenProblemFilter openProblemFilter = new OpenProblemFilter();
    private boolean currentlyDisplayed = false;

    public SelMenuPanelHandler(SynchronousPanelTasklet displayHandle) {
        Trace.trace(TRACE_MASKT, "<> SelMenuPanelHandler ctor");
        this.displayHandle = displayHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void display(Map userData) throws HException {
        Trace.trace(TRACE_MASKT, "-> SelMenuPanelHandler - display");
        this.exit = false;
        SelMenuPanelBean bean = new SelMenuPanelBean();
        bean.setBeanName("SelMenuPanelBeanName");
        this.problemManager = ProblemManager.getProblemManager();
        this.myPropertyChangeListenerAdapter = new PropertyChangeListenerAdapter();
        this.problemManager.addPropertyChangeListener(this.myPropertyChangeListenerAdapter);
        try {
            this.currentlyDisplayed = false;
            Object[] initialKeys = userData.keySet().toArray();
            while (!this.exit) {
                SelMenuPanelHandler.resetMap(userData, initialKeys);
                this.buildOutput(bean, userData);
                if (this.problemMap.size() == 0) {
                    this.exit = true;
                    try {
                        this.displayHandle.showMessageBox(false, new LocalizableText("com.ibm.hwmca.base.res.message", "perfcons.title"), new MessageText[]{new MessageText("com.ibm.hwmca.base.res.message", "XRV00001")}, "XRV00001", MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                        continue;
                    }
                    catch (HException e) {
                        Trace.trace(TRACE_MASKF, "SelMenuPanelHandler.display; exception caught displaying dialog XRV00001[" + e + "]");
                        Trace.trace(TRACE_MASKF, e);
                        throw e;
                    }
                }
                if (!this.currentlyDisplayed) {
                    this.currentlyDisplayed = true;
                    bean = (SelMenuPanelBean)this.displayHandle.replace(XFConstants.RES_FILE_NAME, "SelMenuPanel", bean);
                } else {
                    bean = (SelMenuPanelBean)this.displayHandle.update("SelMenuPanelBeanName", bean);
                }
                Problem selectedProblem = this.getSelectedProblem(bean);
                userData.put("PROBLEM", selectedProblem);
                String event = bean.getActionCommand();
                Trace.trace(TRACE_MASKT, "SelMenuPanelHandler.display - event: " + event);
                if (selectedProblem != null) {
                    while (event.equals("ViewMenu.ProblemAnalysisMenuItem")) {
                        bean = (SelMenuPanelBean)CommonPanelFunctions.launchProblemAnalysis(bean, userData);
                        event = bean.getActionCommand();
                        this.currentlyDisplayed = true;
                    }
                }
                if (event.toUpperCase().equals("CANCEL")) {
                    this.exit = true;
                    continue;
                }
                if (event.startsWith("SortMenu.")) {
                    this.doSort(bean, userData);
                    continue;
                }
                if (event.startsWith("ManageMenu.")) {
                    this.doManage(bean, userData);
                    continue;
                }
                if (event.startsWith("ViewMenu.")) {
                    this.doView(bean, userData);
                    continue;
                }
                if (event.startsWith("CloseMenu.")) {
                    this.doClose(bean, userData);
                    continue;
                }
                Trace.trace(TRACE_MASKF, "SelMenuPanelHandler.handleRequest - unsupported request[" + event + "]");
            }
        }
        finally {
            this.problemManager.removePropertyChangeListener(this.myPropertyChangeListenerAdapter);
        }
        Trace.trace(TRACE_MASKT, "<- SelMenuPanelHandler.handleRequest");
    }

    private void doSort(SelMenuPanelBean bean, Map userData) {
        Object[] o = bean.getProbRept();
        String event = bean.getActionCommand();
        if (event.endsWith(".ByNumberMenuItem")) {
            this.numericComparator.setSortCol(0);
            Arrays.sort(o, this.numericComparator);
        } else if (event.endsWith(".ByDateMenuItem")) {
            this.comparator.setSortCol(1);
            Arrays.sort(o, this.comparator);
        } else if (event.endsWith(".ByReferenceCodeMenuItem")) {
            this.comparator.setSortCol(2);
            Arrays.sort(o, this.comparator);
        } else if (event.endsWith(".ByStatusMenuItem")) {
            this.comparator.setSortCol(3);
            Arrays.sort(o, this.comparator);
        } else {
            Trace.trace(TRACE_MASKF, "SelMenuPanelHandler.doSort - unsupported sort option[" + event + "], sorting by Problem Number");
            this.numericComparator.setSortCol(0);
            Arrays.sort(o, this.numericComparator);
        }
        bean.setProbRept(o);
    }

    private void doManage(SelMenuPanelBean bean, Map userData) throws HException {
        Trace.trace(TRACE_MASKT, "-> SelMenuPanelHandler.doManage");
        String event = bean.getActionCommand();
        if (event.endsWith(".RepairSelectedMenuItem")) {
            Problem problem = (Problem)userData.get("PROBLEM");
            if (problem == null) {
                Trace.trace(TRACE_MASKF, "SelMenuPanelHandler.doManage - a problem was not selected!");
            } else {
                if (!((problem = (Problem)this.problemMap.get(String.valueOf(problem.getProblemNumber()))) instanceof CommonProblem)) {
                    Trace.trace(TRACE_MASKT, "<-! SelMenuPanelHandler.doManage, selected problem is not a CommonProblem[" + problem + "]");
                    throw new HException("SelMenuPanelHandler.doManage, selected problem is not a CommonProblem[" + problem + "]");
                }
                CommonProblem commonProblem = (CommonProblem)problem;
                ServiceAction repair = commonProblem.getServiceAction();
                boolean newRepair = false;
                try {
                    if (repair == null) {
                        ManagedSystem ms = ManagedSystemManager.getManager().getManagedSystem(commonProblem.getFailingSystem().getMachineType(), commonProblem.getFailingSystem().getMachineModel(), commonProblem.getFailingSystem().getMachineSerial());
                        ServiceActionFactory saf = (ServiceActionFactory)ms.getFactory("ServiceActionFactory");
                        repair = saf.create(ServiceActionType.REPAIR_PROBLEM, userData);
                        newRepair = true;
                        Trace.trace(TRACE_MASKF, "SelMenuPanelHandler.doManage; registering new Repair[" + repair + "]");
                        commonProblem.setServiceAction(repair);
                        ProblemManager.getProblemManager().changed(commonProblem);
                    }
                    userData.put("REPAIR", repair);
                    boolean previouslyDelayed = repair.isDelayed();
                    Integer toolMode = (Integer)userData.get("TOOL_MODE");
                    toolMode = toolMode == null ? new Integer(0) : new Integer(toolMode & 0xFFFFFFFD | 0);
                    userData.put("TOOL_MODE", toolMode);
                    repair.start(userData);
                    if (repair.isDelayed() && !previouslyDelayed) {
                        this.setDataUpToDate(false);
                        ProblemManager.getProblemManager().changed(commonProblem);
                    }
                    this.currentlyDisplayed = false;
                }
                catch (HException e) {
                    Trace.trace(TRACE_MASKF, "<-! SelMenuPanelHandler.doManage; HException caught:" + e);
                    Trace.trace(TRACE_MASKF, e);
                    throw e;
                }
            }
        } else if (event.endsWith(".ExitMenuItem")) {
            this.exit = true;
        }
        Trace.trace(TRACE_MASKT, "<- SelMenuPanelHandler.display");
    }

    private void doView(SelMenuPanelBean bean, Map userData) throws HException {
        String event = bean.getActionCommand();
        if (event.endsWith(".ProblemSumMenuItem")) {
            if (userData.get("PROBLEM") == null) {
                Trace.trace(TRACE_MASKF, "SelMenuPanelHandler.doView - a problem was not selected!");
            } else {
                new MachineInfoPanelHandler(this.displayHandle).display(userData);
                this.currentlyDisplayed = false;
            }
        } else if (event.endsWith(".RefreshMenuItem")) {
            // empty if block
        }
    }

    private void doClose(SelMenuPanelBean bean, Map userData) throws HException {
        String event = bean.getActionCommand();
        if (bean.getActionCommand().endsWith(".AllProblemsMenuItem")) {
            try {
                LocalizableText Ok = CommonMsgInterface.OK_BUTTON;
                LocalizableText answer = this.displayHandle.showMessageBox(false, new LocalizableText("com.ibm.hwmca.base.res.message", "perfcons.title"), new MessageText[]{new MessageText("com.ibm.hwmca.base.res.message", "XRV00003")}, "XRV00003", MsgType.QUESTION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON});
                if (answer.equals(Ok)) {
                    Collection c = this.problemMap.values();
                    Iterator i = c.iterator();
                    while (i.hasNext()) {
                        Problem p = (Problem)i.next();
                        userData.put("PROBLEM", p);
                        userData.put("REPAIR", p.getServiceAction());
                        userData.put("FIX_DESCRIPTION", "");
                        userData.put("TOOL_MODE", new Integer(2));
                        XRVUtils.closeProblemAndServiceAction(userData);
                    }
                    this.problemMap.clear();
                    bean.clearProbRept();
                }
            }
            catch (TaskletException e) {
                Trace.trace(TRACE_MASKF, "SelMenuPanelHandler.doClose; exception displaying verification dialog[" + e + "]");
            }
        } else if (event.endsWith(".SelectedProbMenuItem")) {
            int[] selected = bean.getProbReptSelection();
            if (selected != null && selected.length > 0) {
                Trace.trace(TRACE_MASKD, "SelMenuPanelHandler.doClose - problem was selected");
                Object[] table = bean.getProbRept();
                String problemKey = (String)((Object)((Serializable[])table[selected[0]])[0]);
                Problem p = (Problem)this.problemMap.get(problemKey);
                userData.put("PROBLEM", p);
                userData.put("REPAIR", p.getServiceAction());
                userData.put("FIX_DESCRIPTION", "");
                userData.put("TOOL_MODE", new Integer(2));
                XRVUtils.closeProblemAndServiceAction(userData);
                this.problemMap.remove(problemKey);
                bean.removeProbReptRowAt(selected[0]);
                bean.setProbReptSelection(new int[0]);
            } else {
                Trace.trace(TRACE_MASKD, "SelMenuPanelHandler.doClose - problem not selected");
            }
        }
    }

    private void buildOutput(SelMenuPanelBean bean, Map userData) throws HException {
        Trace.trace(TRACE_MASKT, "-> SelMenuPanelHandler.buildOutput");
        if (!this.dataUpToDate) {
            try {
                this.displayHandle.showBusyDialog(new LocalizableText("com.ibm.hwmca.base.res.message", "perfcons.title"), new LocalizableText("com.ibm.hwmca.base.res.text", "perfcons.loadproblems"));
            }
            catch (Exception e) {
                // empty catch block
            }
            ProblemManager pm = ProblemManager.getProblemManager();
            List allProblems = pm.getAllProblems();
            ArrayList openProblems = new ArrayList();
            openProblemFilter.filter(openProblems, allProblems);
            int numProblems = openProblems.size();
            this.problemMap = new HashMap(numProblems);
            Trace.trace(TRACE_MASKF, "SelMenuPanelHandler.buildOutput-#problems found[" + numProblems + "]");
            if (numProblems > 0) {
                bean.clearProbRept();
                boolean row = false;
                for (int aii = 0; aii < numProblems; ++aii) {
                    Problem p = (Problem)openProblems.get(aii);
                    ServiceAction repair = p.getServiceAction();
                    this.problemMap.put(String.valueOf(p.getProblemNumber()), p);
                    Serializable[] lrow = new Serializable[4];
                    lrow[0] = String.valueOf(p.getProblemNumber());
                    lrow[1] = new Date(p.getProblemTimeStamp());
                    lrow[2] = ((CommonProblem)p).getRefcode();
                    if (lrow[2] == null) {
                        lrow[2] = new String("");
                    }
                    lrow[3] = repair != null && repair.isDelayed() ? DELAYED : OPEN;
                    bean.setProbReptRowAt(aii, lrow);
                    Trace.trace(TRACE_MASKD, "SelMenuPanelHandler.buildOutput - adding row to bean");
                }
                Object[] o = bean.getProbRept();
                this.numericComparator.setSortCol(0);
                Arrays.sort(o, this.numericComparator);
                bean.setProbRept(o);
            } else {
                Trace.trace(TRACE_MASKF, "SelMenuPanelHandler.buildOutput-NO open problems!!!");
            }
            this.setDataUpToDate(true);
            try {
                this.displayHandle.destroyBusyDialog();
            }
            catch (Exception e) {}
        } else {
            Trace.trace(TRACE_MASKF, "SelMenuPanelHandler.buildOutput-The data currently displayed is up-to-date");
        }
        Trace.trace(TRACE_MASKT, "<- SelMenuPanelHandler.buildOutput");
    }

    private void setDataUpToDate(boolean dataUpToDate) {
        Trace.trace(TRACE_MASKT, "<> SelMenuPanelHandler.setDataUpToDate[" + dataUpToDate + "]");
        this.dataUpToDate = dataUpToDate;
    }

    private void removeProblemManagerListener() {
        if (this.myPropertyChangeListenerAdapter != null) {
            this.problemManager.removePropertyChangeListener(this.myPropertyChangeListenerAdapter);
            this.myPropertyChangeListenerAdapter = null;
        }
    }

    private Problem getSelectedProblem(SelMenuPanelBean bean) throws HException {
        Problem problem = null;
        int[] selected = bean.getProbReptSelection();
        if (selected != null && selected.length != 0) {
            String problemNumber = ((Object[])bean.getProbRept()[selected[0]])[0].toString();
            Trace.trace(TRACE_MASKD, "SelMenuPanelHandler.doManage, selected problem number[" + problemNumber + "]");
            if (this.problemMap.containsKey(problemNumber)) {
                problem = (Problem)this.problemMap.get(problemNumber);
            } else {
                Trace.trace(TRACE_MASKF, "<-! getSelectedProblem - selected problem number [" + problemNumber + "] doesn't exist");
                throw new HException("internal error - selected problem number [" + problemNumber + "] doesn't exist");
            }
        }
        return problem;
    }

    private static void resetMap(Map userData, Object[] initialKeys) {
        int aii;
        Object[] values = new Object[initialKeys.length];
        for (aii = 0; aii < initialKeys.length; ++aii) {
            values[aii] = userData.get(initialKeys[aii]);
        }
        userData.clear();
        for (aii = 0; aii < initialKeys.length; ++aii) {
            userData.put(initialKeys[aii], values[aii]);
        }
    }

    private static class OpenProblemFilter
    implements ProblemFilter {
        private Problem referenceProblem;

        private OpenProblemFilter() {
        }

        public void filter(List theReturnList, List theProblems) {
            Iterator it = theProblems.iterator();
            while (it.hasNext()) {
                Problem p = (Problem)it.next();
                if (p.getProblemState() != 1 || !(p instanceof CommonProblem)) continue;
                theReturnList.add(p);
            }
        }

        public void setProblem(Problem theProblem) {
            this.referenceProblem = theProblem;
        }

        public Problem getProblem() {
            return this.referenceProblem;
        }
    }

    private class NumericComparatorForSort
    extends ComparatorForSort {
        public int compare(Object o1, Object o2) {
            Integer v1 = Integer.valueOf(((Object[])o1)[this.sortCol].toString());
            Integer v2 = Integer.valueOf(((Object[])o2)[this.sortCol].toString());
            int retval = v1.compareTo(v2);
            return retval;
        }
    }

    private static class ComparatorForSort
    implements Comparator {
        protected int sortCol = 0;

        public int compare(Object o1, Object o2) {
            String s1 = ((Object[])o1)[this.sortCol].toString();
            String s2 = ((Object[])o2)[this.sortCol].toString();
            int retval = s1.compareTo(s2);
            return retval;
        }

        public boolean equals(Object obj) {
            return false;
        }

        public void setSortCol(int sortCol) {
            this.sortCol = sortCol;
        }
    }

    private class PropertyChangeListenerAdapter
    implements PropertyChangeListener {
        private PropertyChangeListenerAdapter() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            SelMenuPanelHandler.this.setDataUpToDate(false);
        }
    }
}

